<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
include('accesstemplate.php');

// class Generic extends CI_Controller {
class Generic extends AccessTemplate {
	
	public function __construct(){
		parent::__construct();
		$this->load->model('seatplans_model', 'seatplans');
		$this->load->model('sections_model', 'sections');
		$this->load->model('transaction_model', 'transaction');
		$this->load->model('events_model', 'events');
		$this->load->model('prices_model', 'prices');
		$this->load->model('tickets_model', 'tickets');
		$this->load->model('ticket_types_model', 'ticket_types');
		$this->load->database('default',true);
	}
	
	function template() {
			
		// the date today
		$today = date("Y-m-d");
		$today = '2013-02-11';
		
		
		
		$dbAccess->select("
				evt.event_code
				, evt.event_title
				, evt.event_long_title
				, evt.event_date_time
			");
			
		$dbAccess->where("evt.event_date_time > '$today 00:00:00'");
		$dbAccess->where("evt.event_date_time < '$today 23:59:59'");
		$dbAccess->where("evt.event_active", 1);
		$query = $dbAccess->get('events evt');
	
	
		$this->load->dbutil();
		
		$config = array (
			  'root'    => 'root',
			  'element' => 'sections', 
			  'newline' => "\n", 
			  'tab'    => "\t"
			);

			
		$xmloutput = $this->dbutil->xml_from_result($query, $config);
		echo $xmloutput;

	}
	

	var $errorMessage = array (
		'ER:00' => 'Incomplete/Invalid Parameters.',
		'ER:01' => 'Invalid access.',
		'ER:02' => 'Inactive KEY',
		'ER:04' => 'In',
		'ER:05' => 'Relay problem and error encountered while storing data. Please contact MGI.',
		'ER:06' => 'Relay problem and error encountered while storing data. Please contact MGI.',
		);
	
	
	//============================== D A T A S Y N C  M O D E  =======================================
	//======= P a r t y L i n e   A u t h e n t i c a t i o n   P r o t o c o l =======
	function Verify_partyid(){
		
		//initialize parameters
		$partycode = $this->input->get_post('partycode');
		$usecode = $this->input->get_post('usecode');
		$appcodeduration = $this->config->item("appcode_expiry");
		$dbAccess = $this->load->database('default',true);

		//Check if parameters are empty
		if(!$partycode){
			$this->promptError('ER:01:01');
		}
		elseif(!$usecode){
			$this->promptError('ER:01:02');
		}else{
		
		//Check existence of partycode &&  usecode..Returns true if exists
		if($this->verifyparty($partycode,$usecode))
					{
							/*
							//Other Checkpoints 
							//Check if browser .. get browser used
								
								if ($this->agent->is_browser()){
								$agent = $this->agent->browser().' '.$this->agent->version();
								}//if robot..
								elseif ($this->agent->is_robot()){
								$agent = $this->agent->robot();
								}//if mobile..
								elseif ($this->agent->is_mobile()){
								$agent = $this->agent->mobile();
								}
								
								else
								{
								$agent = 'ERROR: Unidentified User Agent';
								$data['content'] = $agent;
								}

								//if valid user agent...
								
								 if($agent != 'ERROR: Unidentified User Agent')
									{
									*/
												
								//Get partyCredentials
								$partycredentials = array(
								'platform' =>  $this->agent->platform(),
								'browser' =>  $this->agent->browser().' '.$this->agent->version(),
								'ipaddress' =>  $this->input->ip_address(),
								'referrer:' => $this->agent->referrer()
								);
/* 								
								//Check Referrers from DB based on submitted credentials
								$dbAccess->select("API_HTTP_REFERER");
								$dbAccess->where("api_partycode", $partycode);
								$dbAccess->where("API_HTTP_REFERER",  $this->agent->referrer());
								$query = $dbAccess->get('api_gateways');
										
										if ($query->num_rows() < 1)
											{ echo "Directory Access is forbidden";}
											else{ */
											
											//EXECUTE!
											//Issue an AppCode
											$appcode = $this->generateAppCode($partycode,$usecode,$this->getcurrentdatetime());

											//Save Appcode into api_sessions
											$data = array(
										   'api_partycode' => $partycode,
										   'api_apppcode' => $appcode,
										   'api_livetoken' => 0,
										   'api_duration' => $appcodeduration,
										   'api_gen_active' => 1,
										   'api_time_issued' => $this->getcurrentdatetime(),
										   'api_session_browser' => $partycredentials['browser'],
										   'api_party_ip' => $partycredentials['ipaddress']
											);
											$this->db->insert('api_sessions', $data); 

											$data['content'] = $appcode;

										$xml = '<appcode>'. $appcode.'</appcode>
												<dateTimeActivated>'.$this->getcurrentdatetime().'</dateTimeActivated>
												<expiration>'.$appcodeduration.'</expiration>';
												
												$data['content'] = $xml;	

											// }											
							// }	
							$this->load->view("appcode_xml", $data);
					}
			
					else
					{
						$this->promptError('ER:02:02');
					}
		}
	}

	function Initialize_partyline(){
	$dbAccess = $this->load->database('default',true);
	$appcode = $this->input->get_post('appcode');
	$livetoken = false;

			
			if(!$appcode){
				$this->promptError('ER:01:03');
			}else{
	
				//Check if appcode exist
				if (!$this->checkappcode($appcode))
				{
					$this->promptError('ER:02:01');
				
				}
				else
				{
					
				//Check if there is a LiveToken already issued
					$dbAccess->select("api_livetoken");
					$dbAccess->where("api_apppcode", $appcode);
					$query = $dbAccess->get('api_sessions');

				if ($query->num_rows() == 1)
				{

							//Check if appcode is still valid..if valid..
							if (!$this->checksessionexpiration($appcode,0))
							{
								//issue LiveToken
								$livetoken = $this->generatelivetoken($appcode);

								//Get partyCredentials
								$partycredentials = $this->getpartycredentials();
								
									$this->session_deactivate($appcode,0);
								
								//Save LiveToken into api_sessions
									$data = array(
								   'api_partycode' => $this->getpartycodebyappcode($appcode),
								   'api_apppcode' => $appcode,
								   'api_livetoken' => $livetoken,
								   'api_duration' => $this->config->item("livetoken_expiry"),
								   'api_gen_active' => 1,
								   'api_time_issued' => $this->getcurrentdatetime(),
								   'api_session_browser' => $partycredentials['browser'],
								   'api_party_ip' => $partycredentials['ipaddress']
									);
									$this->db->insert('api_sessions', $data); 	
									
										$data['content'] =  $livetoken;
										
										
										$xml = '<livetoken>'. $livetoken.'</livetoken>
										<dateTimeActivated>'.$this->getcurrentdatetime().'</dateTimeActivated>
										<expiration>'.$this->config->item("livetoken_expiry").'</expiration>';
										
										$data['content'] = $xml;	

										$this->load->view("livetoken_xml", $data);										
			
							}
							else
							{
							// $data['content'] = 'Appcoded Expired';
							
							$this->promptError('ER:03:02');
							}
				}
					else
					{
					$this->promptError('ER:02:04');
					
					}
				}
				
			}				
					
	}

	function Refresh_party(){
	$livetoken = $this->input->get_post('livetoken');
	$appcode = $this->input->get_post('appcode');

	//Check if parameters are empty
	if(!$appcode){
		// $data['content'] = 'ERROR: No AppCode Provided';
		$this->promptError('ER:01:03');
	}
	elseif(!$livetoken){
		// $data['content'] = 'ERROR: No LiveToken Provided';
		$this->promptError('ER:01:04');
	}else{
		
		//Checks the validity of $appcode && $livetoken
		if ($this->validatesession($this->input->get_post('appcode'),$this->input->get_post('livetoken')))
		{

						//Check if Expired..if not yet expired..
							if(!$this->checksessionexpiration($appcode,$livetoken))
							{
								//Deactivate an $appcode/$livetoken
								$this->session_deactivate($appcode,$livetoken);
									
								//issue LiveToken
								$livetoken = $this->generatelivetoken($appcode);

								//Get partyCredentials
								$partycredentials = $this->getpartycredentials();

								//Save LiveToken into api_sessions
									$data = array(
								   'api_partycode' => $this->getpartycodebyappcode($appcode),
								   'api_apppcode' => $appcode,
								   'api_livetoken' => $livetoken,
								   'api_duration' => $this->config->item("livetoken_expiry"),
								   'api_gen_active' => 1,
								   'api_time_issued' => $this->getcurrentdatetime(),
								   'api_session_browser' => $partycredentials['browser'],
								   'api_party_ip' => $partycredentials['ipaddress']
									);
									$this->db->insert('api_sessions', $data); 	

								
										$data['content'] = $livetoken;
											
										$xml = '<livetoken>'. $livetoken.'</livetoken>
										<dateTimeActivated>'.$this->getcurrentdatetime().'</dateTimeActivated>
										<expiration>'.$this->config->item("livetoken_expiry").'</expiration>';
										
										$data['content'] = $xml;		
										$this->load->view("livetoken_xml", $data);	
											
											
							}

						else
						{
						// $data['content'] =  'LiveToken Expired';
						$this->promptError('ER:03:01');
						}
			}
			else
			{
			// $data['content'] =  'Invalid Key Pair';
			$this->promptError('ER:02:02');
			}
		
	}
	}
	//----------------------------------------------------------------------------------
		
	
	//=============== U t i l i t y  F u n c t i o n s =================================
	function Register_party_user(){

	$livetoken = $this->input->get_post('livetoken');
	$appcode = $this->input->get_post('appcode');

	//Check if parameters are empty
	if(!$appcode){
	// $data['content'] = 'ERROR: No AppCode Provided';
	$this->promptError('ER:01:03');
	}
	elseif(!$livetoken){
	// $data['content'] = 'ERROR: No LiveToken Provided';
	$this->promptError('ER:01:04');
	}else{
		
		////Checks the existence of $appcode && $livetoken
		if (!$this->validatesession($appcode,$livetoken))
		{		
			// $data['content'] = 'Invalid  Key Pair';}
			$this->promptError('ER:01:06');
		}
		//Check if Expired..if not yet expired..if not...
		elseif($this->checksessionexpiration($appcode,$livetoken))
			{ 
			// $data['content'] = 'LiveToken Expired';}
			$this->promptError('ER:03:01');
			}
			else{

			$customer_partycode = $this->getpartycodebyappcode($appcode);
			$this->load->helper('email');
			$appcode = $this->input->post('appcode');
			$customer_username = $this->input->post('username');
			$customer_firstname = $this->input->post('fname');
			$customer_middlename = $this->input->post('mname');
			$customer_lastname = $this->input->post('lname');
			$customer_birthdate = $this->input->post('bdate');
			$customer_mobile = $this->input->post('mobile');
			$customer_email = $this->input->post('email');
			$customer_password = $this->input->post('pass');
			
			//HARDCODE for the meantime-----------------------------------------------------
				// $appcode = $this->input->post('appcode');
				// $customer_firstname = 'Kabir';
				// $customer_middlename = 'David';
				// $customer_lastname = 'Solomon';
				// $customer_birthdate = '2013-02-15';
				// $customer_mobile = '09271234567';
				// $customer_email = 'Mushkila@abc.com';
				// $customer_password = '1234';
				// $customer_username = 'Caliph';
			//-------------------------------------------------------------------------------
				//Check Password
				if(!$customer_username)
					{ 
					$this->promptError('ER:04:12');
					}	
				elseif($this->check_username($customer_username))
				{ 
					$this->promptError('ER:04:13');
				}					
				elseif(!$customer_password)
					{ 
					// $customer_password = 'ERROR: No Password Provided';
					$this->promptError('ER:04:03');
					}
				
				//Check FirstName
				elseif(!trim($customer_firstname))
					{
					// $customer_firstname = 'ERROR: No First Name Provided';
					$this->promptError('ER:04:04');
					}
					
					//Check LastName
				elseif(!trim($customer_lastname))
					{ 
					// $customer_lastname = 'ERROR: No Last Name Provided';
					$this->promptError('ER:04:05');
					}	
					
					
				//Check Date..Date should be in YYYY-MM-DD
				elseif (!$customer_birthdate)
						{
						// $customer_birthdate = 'ERROR: No Birth Date Provided';
						$this->promptError('ER:04:06');
						}
						
				//Returns TRUE if date format = YYYY-MM-DD
				elseif(!$this->isValidDate($customer_birthdate))
				{
				// $customer_birthdate = 'ERROR: Invalid date format';
				$this->promptError('ER:04:07');
				} 	
				//Check mobile
				elseif( !$customer_mobile)
				{ 
				// $customer_mobile = 'ERROR: No Mobile Number Provided';
				$this->promptError('ER:04:08');
				} 				
				elseif(!$this->validate_phonenumbers($customer_mobile))
				{ 
				// $customer_mobile = 'ERROR:Invalid Mobile Format';
				$this->promptError('ER:04:11');
				} 
				//Check if email Adress string is valid
				elseif(!$customer_email)
				{ 
					// $customer_email = 'ERROR: No Email Provided';
					$this->promptError('ER:04:10');
				}
					
				//Check if email Adress string is valid
				elseif(!valid_email($customer_email))
				{ 
					// $customer_email = 'ERROR: Invalid Email Format';
					$this->promptError('ER:04:09');
				}else{		
						$data = array(
					   'api_customer_firstname' => $customer_firstname,
					   'api_customer_firstname' => $customer_firstname,
					   'api_customer_middlename' => $customer_middlename,
					   'api_customer_lastname' => $customer_lastname,
					   'api_customer_birthdate' => $customer_birthdate,
					   'api_customer_mobile' => $customer_mobile,
					   'api_customer_email' => $customer_email,
					   'api_customer_username' => $customer_username,
					   'api_customer_password' => $this->prep_password($customer_password),
					   'api_customer_partycode' => $customer_partycode
						);
				 
					
						// I N S E R T		T O		D A T A B A S E
						$this->db->insert('api_party_customers', $data); 	
						
						$xml = '<result>Registration Succesful</result>';
						foreach ($data as $key=>$value) 
						{
							if(substr($key, 13) !== 'password')
							{
								$xml = $xml . '<' .  substr($key, 13)  .'>' . $value . '</' . substr($key, 13). '>';
							}
						}	
						$data['content'] = $xml;
						$this->load->view("register_party_user_xml", $data);
			
					}
				}
			
			
			}
	}
				
	function Update_party_user(){

		$this->load->helper('email');
		$appcode = $this->input->get_post('appcode');
		$livetoken = $this->input->get_post('livetoken');
		$customer_id = $this->input->get_post('cid');
		
		////Checks the existence of $appcode && $livetoken
		if (!$this->validatesession($appcode,$livetoken))
		{		$data['content'] = 'Invalid  key pair';}

		//Check if Expired..if not yet expired..if not...
		elseif($this->checksessionexpiration($appcode,$livetoken))
			{ $data['content'] = 'LiveToken Expired';}
			else{

		$customer_partycode = $this->getpartycodebyappcode($appcode);

		// // $customer_firstname = $this->input->post('fname');
		// // $customer_middlename = $this->input->post('mname');
		// // $customer_lastname = $this->input->post('lname');
		// // $customer_birthdate = $this->input->post('bdate');
		// // $customer_mobile = $this->input->post('mobile');
		// // $customer_email = $this->input->post('email');
		// // $customer_password = $this->input->post('pass');
		
		//HARDCODE for the meantime-----------------------------------------------------
		
			// $customer_id = '1';
			// $customer_firstname = 'Juan';
			// $customer_middlename = '';
			// $customer_lastname = 'dela Cruz';
			// $customer_birthdate = '1991-01-01';
			// $customer_mobile = 923456789;
			// $customer_email = 'email@email.com';
			// $customer_password = '1234';
			
		//-------------------------------------------------------------------------------
			//Check Password
			if(!$customer_password)
				{ $customer_password = 'ERROR: No Password Provided';}
				else{$customer_password = $this->prep_password($customer_password);}
			
			//Check FirstName
			if(!$customer_firstname)
				{ $customer_firstname = 'ERROR: No First Name Provided';}
				
				//Check LastName
			if(!$customer_lastname)
				{ $customer_lastname = 'ERROR: No Last Name Provided';}	
	
			//Check Date..Date should be in YYYY-MM-DD
			if (!$customer_birthdate)
					{$customer_birthdate = 'ERROR: No Birth Date Provided';}
					
			//Returns TRUE if date format = YYYY-MM-DD
			if(!$this->isValidDate($customer_birthdate))
				{$customer_birthdate = 'ERROR: Invalid date format';}
				
			if($this->checkmobilenumber($customer_id,$customer_mobile ))
			{ $customer_mobile = 'ERROR: Mobile number already existing';}
				
			//Check mobile
			if( !$customer_mobile)
			{ $customer_mobile = 'ERROR: No Mobile Number Provided';}

			
			//Check if email Adress string is valid
			if(!$customer_email)
					{ $customer_email = 'ERROR: No Email Provided';}
				
			//Check if email Adress string is valid
			if(!valid_email($customer_email))
					{ $customer_email = 'ERROR: Invalid Email Format';}	
				
			//Check duplicate email
			if($this->checkemail($customer_id,$customer_email ))
			{ $customer_email = 'ERROR: Email Already Used';}			

			
				$data = array(
			   'api_customer_firstname' => $customer_firstname,
			   'api_customer_middlename' => $customer_middlename,
			   'api_customer_lastname' => $customer_lastname,
			   'api_customer_birthdate' => $customer_birthdate,
			   'api_customer_mobile' => $customer_mobile,
			   'api_customer_email' => $customer_email,
			   'api_customer_username' => $customer_email,
			   'api_customer_password' => $customer_password,
			   'api_customer_partycode' => $customer_partycode
				);
					
			//Check if there is an error
			$xml = '<root>';
			$xml = $xml . '<result>Update Failed</result>';
			foreach ($data as $key=>$value) 
			{	if (strpos($value,'ERROR:') !== false) {
				$xml = $xml . '<' .  substr($key, 13)  .'>' . $value . '</' . substr($key, 13). '>';
				}
			}	
				$xml = $xml . '</root>';
 
								//If no error..
								if (strpos($xml,'ERROR:') == false)
								{
											// U  P D A T E 	D A T A B A S E

											$this->db->where('api_customer_id', $customer_id);
											$this->db->update('api_party_customers', $data);
		
											$xml = '<root>';
											$xml = $xml . '<result>Update Succesful</result>';
											foreach ($data as $key=>$value) 
											{
												if(substr($key, 13) !== 'password')
												{
													$xml = $xml . '<' .  substr($key, 13)  .'>' . $value . '</' . substr($key, 13). '>';
												}
											}	
												$xml = $xml . '</root>';
											$data['content'] = $xml;
								}
			else
			{
			$data['content'] = $xml;

			}
		
			}
		$this->load->view("register_party_user_xml", $data);
		}
	
	function ForgotPassword(){
	
		$appcode = $this->input->get_post('appcode');
		$livetoken = $this->input->get_post('livetoken');
		// $bdate = $this->input->get_post('bdate');
		$email = $this->input->get_post('email');
		$newpass = $this->input->get_post('pass');
		
		// Checks the existence of $appcode && $livetoken
		if (!$this->validatesession($appcode,$livetoken))
		{$data['content'] = 'Invalid Key Pair';}
		
			
		
		// Check if Expired..if not yet expired..if not...
		elseif($this->checksessionexpiration($appcode,$livetoken))
			{ $data['content'] = 'LiveToken expired';}
			else{
					if(!$newpass)
					{ $newpass = 'ERROR: No Password Provided';}
					else{$newpass = $this->prep_password($newpass);}

		$dbAccess = $this->load->database('default',true);
		$dbAccess->select("
				api_party_customers.api_customer_id
			");
		$dbAccess->where("api_customer_email", $email);
		// $dbAccess->where("api_customer_birthdate", $bdate);
		$query = $dbAccess->get('api_party_customers');
	
			if ($query->num_rows() > 0)
			{
							$dbAccess = $this->load->database('default',true);
							$data = array('api_customer_password' => $newpass);
							$dbAccess->where('api_customer_email',$email);
							$dbAccess->update('api_party_customers', $data); 	
			
							$xml = '<result> Password Succesfully Updated</result>';
									$data['content'] = $xml;
			}
			else
			{
			$data['content'] = 'Username/email does not exist';
			}	
				}

			$this->load->view("forgot_password_xml", $data);
	}
	

	
	

// U t i l i t y 	F u n c t i o n s   r e q u e s t e d   b y   S i r   K i t / A n d r e i
	function ViewAPIuserbyUsername(){
		$appcode = $this->input->get_post('appcode');
		$livetoken = $this->input->get_post('livetoken');
		$username = $this->input->get_post('username');
			
		if(!$appcode){
			$this->promptError('ER:01:03');
		}elseif(!$livetoken){
			$this->promptError('ER:01:04');
		}elseif(!$username){
			$this->promptError('ER:04:12');
		}

		else{
		
				//Checks the existence of $appcode && $livetoken
				if(!$this->validatesession($appcode,$livetoken))
				{
				// echo 'Invalid key pair';
				$this->promptError('ER:02:02');
				}
				
				//Check if Expired..if not yet expired..if not...
				elseif($this->checksessionexpiration($appcode,$livetoken))
				{ 
					// echo 'liveToken expired';
					$this->promptError('ER:03:01');
				}
				else{
				
					$dbAccess = $this->load->database('default',true);
				
				$dbAccess->select("
							pc.api_customer_id
							,pc.api_customer_username 
							, pc.api_customer_firstname
							, pc.api_customer_middlename
							, pc.api_customer_lastname
							, pc.api_customer_birthdate
							, pc.api_customer_mobile
							, pc.api_customer_email
							, pc.api_customer_partycode
							");

						$dbAccess->where("pc.api_customer_username", $username);
						$query = $dbAccess->get('api_party_customers pc');	

						$data['user'] = $query->row();
								
						if($query->num_rows() < 1){
									$this->promptError('ER:04:15');
								}else{
								//display the page
								$this->load->view('user_xml', $data);
								}
				
				
				}
	
			}
	}
	
	function ViewAPIuserbyEmail(){
		$appcode = $this->input->get_post('appcode');
		$livetoken = $this->input->get_post('livetoken');
		$email = $this->input->get_post('email');
			
		if(!$appcode){
			$this->promptError('ER:01:03');
		}elseif(!$livetoken){
			$this->promptError('ER:01:04');
		}elseif(!$email){
			$this->promptError('ER:04:10');
		}

		else{
		
				//Checks the existence of $appcode && $livetoken
				if(!$this->validatesession($appcode,$livetoken))
				{
				// echo 'Invalid key pair';
				$this->promptError('ER:02:02');
				}
				
				//Check if Expired..if not yet expired..if not...
				elseif($this->checksessionexpiration($appcode,$livetoken))
				{ 
					// echo 'liveToken expired';
					$this->promptError('ER:03:01');
				}
				else{
				
					$dbAccess = $this->load->database('default',true);
				
				$dbAccess->select("
							pc.api_customer_id
							,pc.api_customer_username 
							, pc.api_customer_firstname
							, pc.api_customer_middlename
							, pc.api_customer_lastname
							, pc.api_customer_birthdate
							, pc.api_customer_mobile
							, pc.api_customer_email
							, pc.api_customer_partycode
							");

						$dbAccess->where("pc.api_customer_email", $email);
						$query = $dbAccess->get('api_party_customers pc');	

						$data['user'] = $query->row();
								
						if($query->num_rows() < 1){
									$this->promptError('ER:04:14');
								}else{
								//display the page
								$this->load->view('user_xml', $data);
								}
				
				
				}
	
			}
	}
	
	
	function ViewLegacyUserbyUsername(){
		$appcode = $this->input->get_post('appcode');
		$livetoken = $this->input->get_post('livetoken');
		$username = $this->input->get_post('username');
			
		if(!$appcode){
			$this->promptError('ER:01:03');
		}elseif(!$livetoken){
			$this->promptError('ER:01:04');
		}elseif(!$username){
			$this->promptError('ER:04:12');
		}

		else{
		
				//Checks the existence of $appcode && $livetoken
				if(!$this->validatesession($appcode,$livetoken))
				{
				// echo 'Invalid key pair';
				$this->promptError('ER:02:02');
				}
				
				//Check if Expired..if not yet expired..if not...
				elseif($this->checksessionexpiration($appcode,$livetoken))
				{ 
					// echo 'liveToken expired';
					$this->promptError('ER:03:01');
				}
				else{
				
					$dbAccess = $this->load->database('default',true);
				
				$dbAccess->select("
							c.customer_id 
							, c.customer_username 
							, c.customer_username 
							, c.customer_firstname
							, c.customer_middlename
							, c.customer_lastname
							, c.customer_birthdate
							, c.customer_mobile
							, c.customer_email
							");

						$dbAccess->where("c.customer_username", $username);
						$query = $dbAccess->get('customers c');	

						$data['user'] = $query->row();
								
						if($query->num_rows() < 1){
									$this->promptError('ER:04:15');
								}else{
								//display the page
								$this->load->view('legacy_user_xml', $data);
								}
				
				
				}
	
			}
	}
	
	function ViewLegacyUserbyEmail(){
		$appcode = $this->input->get_post('appcode');
		$livetoken = $this->input->get_post('livetoken');
		$email = $this->input->get_post('email');
			
		if(!$appcode){
			$this->promptError('ER:01:03');
		}elseif(!$livetoken){
			$this->promptError('ER:01:04');
		}elseif(!$email){
			$this->promptError('ER:04:10');
		}

		else{
		
				//Checks the existence of $appcode && $livetoken
				if(!$this->validatesession($appcode,$livetoken))
				{
				// echo 'Invalid key pair';
				$this->promptError('ER:02:02');
				}
				
				//Check if Expired..if not yet expired..if not...
				elseif($this->checksessionexpiration($appcode,$livetoken))
				{ 
					// echo 'liveToken expired';
					$this->promptError('ER:03:01');
				}
				else{
				
					$dbAccess = $this->load->database('default',true);
				
				$dbAccess->select("
							c.customer_id 
							, c.customer_username 
							, c.customer_firstname
							, c.customer_middlename
							, c.customer_lastname
							, c.customer_birthdate
							, c.customer_mobile
							, c.customer_email
							");

						$dbAccess->where("c.customer_email", $email);
						$query = $dbAccess->get('customers c');	

						$data['user'] = $query->row();
								
						if($query->num_rows() < 1){
									$this->promptError('ER:04:14');
								}else{
								//display the page
								$this->load->view('legacy_user_xml', $data);
								}
				
				
				}
	
			}
	}
	
	
	
	
	
	
	
	
	
	
	// kay Dre lang 'to	.. 0 -> exist, 1->does not exist
	function CheckAPIuser(){
	
		$user_id = $this->input->get_post('userid');
		$password = $this->input->get_post('password');
			
		if(!$user_id){
			$this->promptError('ER:01:09');
		}elseif(!$password){
			$this->promptError('ER:01:05');
		}

		else{
					
				$dbAccess = $this->load->database('default',true);
						
				$dbAccess->select("a.api_customer_id");
				$dbAccess->where("a.api_customer_id", $user_id);
				$dbAccess->where("a.api_customer_password", $this->prep_password($password));
				$query = $dbAccess->get('api_party_customers a');	

					if ($query->num_rows() > 0)
						{
							$data['user'] = 0;
						}
					else
						{
						$data['user'] = 1;
						}
								$this->load->view('check_user', $data);
			}
}
	
	function CheckLegacyUser(){
	
		$user_id = $this->input->get_post('userid');
		$password = $this->input->get_post('password');
			
		if(!$user_id){
			$this->promptError('ER:01:09');
		}elseif(!$password){
			$this->promptError('ER:01:05');
		}

		else{
					
				$dbAccess = $this->load->database('default',true);
						
				$dbAccess->select("c.customer_id");
				$dbAccess->where("c.customer_id", $user_id);
				$dbAccess->where("c.customer_password", $this->prep_password($password));
				$query = $dbAccess->get('customers c');	

					if ($query->num_rows() > 0)
						{
							$data['user'] = 0;
						}
					else
						{
						$data['user'] = 1;
						}
								$this->load->view('check_user', $data);
			}
}
	
	function CheckLegacybyName(){
	
		$fname = $this->input->get_post('fname');
		$lname = $this->input->get_post('lname');
		$mobile = $this->input->get_post('mobile');
			
		if(!$fname){
			$this->promptError('ER:04:04');
		}elseif(!$lname){
			$this->promptError('ER:04:05');
		}elseif(!$mobile){
			$this->promptError('ER:04:08');
		}

		else{
					
				$dbAccess = $this->load->database('default',true);
						
				$dbAccess->select("c.customer_id");
				$dbAccess->where("c.customer_firstname",$fname);
				$dbAccess->where("c.customer_lastname",$lname);
				$dbAccess->where("c.customer_mobile",$mobile);
				$query = $dbAccess->get('customers c');	

					if ($query->num_rows() > 0)
						{
							$data['user'] = 0;
						}
					else
						{
						$data['user'] = 1;
						}
								$this->load->view('check_user', $data);
			}
}
	
	function CheckAPIbyName(){
	
		$fname = $this->input->get_post('fname');
		$lname = $this->input->get_post('lname');
		$mobile = $this->input->get_post('mobile');
			
		if(!$fname){
			$this->promptError('ER:04:04');
		}elseif(!$lname){
			$this->promptError('ER:04:05');
		}elseif(!$mobile){
			$this->promptError('ER:04:08');
		}

		else{
					
				$dbAccess = $this->load->database('default',true);
						
				$dbAccess->select("a.api_customer_id");
				$dbAccess->where("a.api_customer_firstname",$fname);
				$dbAccess->where("a.api_customer_lastname",$lname);
				$dbAccess->where("a.api_customer_mobile",$mobile);
				$query = $dbAccess->get('api_party_customers a');	

					if ($query->num_rows() > 0)
						{
							$data['user'] = 0;
						}
					else
						{
						$data['user'] = 1;
						}
								$this->load->view('check_user', $data);
			}
}
	

	//------------------------------------------------	
	
	
	
	
	//=============== G e n e r i c   D a t a   F u n c t i o n s ===============
	
	function GetActiveEventsToday(){
	
	$date = new DateTime(null, new DateTimeZone('Asia/Manila'));
	$today = $date->format('Y-m-d');
	
	
	//$today = '2013-01-25';
	
	$appcode = $this->input->get_post('appcode');
	$livetoken = $this->input->get_post('livetoken');
		
		if(!$appcode){
			$this->promptError('ER:01:03');
		}elseif(!$livetoken){
			$this->promptError('ER:01:04');
		}else{
			
			// Checks the existence of $appcode && $livetoken
			if (!$this->validatesession($appcode,$livetoken))
			{
				// echo '$appcode/$livetoken does not exist';
				$this->promptError('ER:02:02');
			}
			
			// Check if Expired..if not yet expired..if not...
			elseif($this->checksessionexpiration($appcode,$livetoken))
				{ 
					// echo '$Appcode/$liveToken expired';
					$this->promptError('ER:03:01');
				}
				else{	
				
					$dbAccess = $this->load->database('default',true);
					
					$dbAccess->select("
							evt.event_id
							,evt.event_code
							, evt.event_long_title
							, evt.event_date_time
							, evt.event_internet_sales_charge as convenience_charge
							, ec.events_config_ekbarcode_active
						");

						
					
					$dbAccess->join('events_config ec', 'ec.events_config_eventid = evt.event_id');				
					$dbAccess->like('evt.event_date_time', $today, 'after');
					$dbAccess->where("evt.event_active", 1);
					$query = $dbAccess->get('events evt');

					if($query->num_rows() < 1){
						$this->promptError('ER:05:09');
					}else{
						$data['eventDetails'] = $query->result();

						//display the page
						$this->load->view('get_active_events_today_xml', $data);
					}	
				}
		}
	}
	
	function getActiveEventbyid() {
		
		$appcode = $this->input->get_post('appcode');
		$livetoken = $this->input->get_post('livetoken');
		$eventid = $this->input->get_post('eventid');
		
		
		if(!$appcode){
			$this->promptError('ER:01:03');
		}elseif(!$livetoken){
			$this->promptError('ER:01:04');
		}else{
		
			if (!$eventid)
			{
				// echo 'ER:05:03 No  Event ID Provided';
				$this->promptError('ER:05:03');
			}else{
			
				//Checks the existence of $appcode && $livetoken
				if(!$this->validatesession($appcode,$livetoken))
				{
				// echo 'Invalid key pair';
				$this->promptError('ER:02:02');
				}
				
				//Check if Expired..if not yet expired..if not...
				elseif($this->checksessionexpiration($appcode,$livetoken))
				{ 
					// echo 'liveToken expired';
					$this->promptError('ER:03:01');
				}
				else{	
					 
						$dbAccess = $this->load->database('default',true);
						
					
						$dbAccess->select("
								evt.event_id
								,evt.event_code
								, evt.event_long_title
								, evt.event_date_time
								, evt.event_internet_sales_charge as convenience_charge
								, ec.events_config_ekbarcode_active
							");
							
						$dbAccess->join('events_config ec', 'ec.events_config_eventid = evt.event_id');
						$dbAccess->where("evt.event_active", 1);
						$dbAccess->where("evt.event_id", $eventid);
						$query = $dbAccess->get('events evt');
						
						$data['active_events'] = $query->row();
								
						if($query->num_rows() < 1){
									$this->promptError('ER:05:04');
								}else{
								//display the page
								$this->load->view('active_events_by_id_xml', $data);
								}
				
				}
			}
		}		
			
	}
	
	function eventdetailsbyID() {
		$eventid = $this->input->get_post('eventid');
		$appcode = $this->input->get_post('appcode');
		$livetoken = $this->input->get_post('livetoken');
		
	
		
		if(!$appcode){
			$this->promptError('ER:01:03');
		}elseif(!$livetoken){
			$this->promptError('ER:01:04');
		}elseif (!$eventid)
		{
			// echo 'ER:05:03 No  Event ID Provided';
			$this->promptError('ER:05:03');
		}else{
		
			//Checks the existence of $appcode && $livetoken
			if (!$this->validatesession($appcode,$livetoken))
			{$this->promptError('ER:02:02');}
			
			//Check if Expired..if not yet expired..if not...
			elseif($this->checksessionexpiration($appcode,$livetoken))
				{ $this->promptError('ER:03:01');}
				else{ 
				
					$dbAccess = $this->load->database('default',true);
					
					
				$queryString ="SELECT 
				`evt`.`event_id`
				, `evt`.`event_code`
				, `evt`.`event_long_title`
				, `evt`.`event_date_time`
				, `evt`.`event_description`
			    , `evt`.`event_image`
				, `evt`.`event_seatplan_id`
				, `s`.`seatplan_image`
				, `evt`.`event_venue_id`
				, `evt`.`event_internet_sales_charge` AS convenience_charge
				, `evt`.`event_type`
				, `ec`.`events_config_ekbarcode_active`

				FROM (`events` evt)
				JOIN `events_config` ec ON `ec`.`events_config_eventid` = `evt`.`event_id`
				JOIN `seatplans` s ON `s`.`seatplan_id` = `evt`.`event_seatplan_id`
				WHERE `evt`.`event_active` = 1 and `evt`.`event_id` = " . $eventid;

					$query = $dbAccess->query($queryString);
					$data['eventDetails'] = $query->row();
					if($query->num_rows() < 1){
						$this->promptError('ER:05:04');
					}else{
						//display the page
						$this->load->view('event_details_by_id_xml', $data);
					}
				 }
		}		
			
	}

	function GetActiveEventsFull(){
	
		$appcode = $this->input->get_post('appcode');
		$livetoken = $this->input->get_post('livetoken');

		if(!$appcode){
			$this->promptError('ER:01:03');
		}elseif(!$livetoken){
			$this->promptError('ER:01:04');
		}else{
		
			// Checks the existence of $appcode && $livetoken
			if (!$this->validatesession($appcode,$livetoken))
			{
				// echo 'Invalid key pair';
				$this->promptError('ER:02:02');
			}
			
			// Check if Expired..if not yet expired..if not...
			elseif($this->checksessionexpiration($appcode,$livetoken))
				{ 
					// echo 'LiveToken expired';
					$this->promptError('ER:03:01');
				}
				else{	 

			$dbAccess = $this->load->database('default',true);
		
		$queryString = "SELECT 
		`evt`.`event_id`
		, `evt`.`event_code`
		, `evt`.`event_long_title`
		, `evt`.`event_date_time`
		, `evt`.`event_description`
		,  evt.event_image
		, `evt`.`event_seatplan_id`
		
		, `s`.`seatplan_image`
		, `evt`.`event_venue_id`
		, `evt`.`event_internet_sales_charge` as convenience_charge
		, `evt`.`event_type`
		, `ec`.`events_config_ekbarcode_active` 		
		, `evt`.`event_active`
		, `evt`.`event_ticket_types`
		FROM (`events` evt) 
		LEFT JOIN `events_config` ec ON `ec`.`events_config_eventid` = `evt`.`event_id` 
		LEFT JOIN `seatplans` s ON `s`.`seatplan_id` = `evt`.`event_seatplan_id` 
		WHERE `evt`.`event_active` = 1";
		
		
		
		$query = $dbAccess->query($queryString);
		$data['eventDetails'] = $query->result();
			

			//display the page
			$this->load->view('event_details_xml', $data);
		 }
	 }
	}
		
	function GetActiveEvents(){
	
		$appcode = $this->input->get_post('appcode');
		$livetoken = $this->input->get_post('livetoken');
		
		if(!$appcode){
			$this->promptError('ER:01:03');
		}elseif(!$livetoken){
			$this->promptError('ER:01:04');
		}else{
			
				// Checks the existence of $appcode && $livetoken
				if (!$this->validatesession($appcode,$livetoken))
				{$this->promptError('ER:02:02');}
				
				// Check if Expired..if not yet expired..if not...
				elseif($this->checksessionexpiration($appcode,$livetoken))
					{ $this->promptError('ER:03:01');}
				else{	

					$dbAccess = $this->load->database('default',true);

					$dbAccess->select("
							evt.event_id
							,evt.event_code
							, evt.event_title
							, evt.event_long_title
							, evt.event_date_time
							, evt.event_internet_sales_charge as convenience_charge
							, ec.events_config_ekbarcode_active
						");
						
					$dbAccess->join('events_config ec', 'ec.events_config_eventid = evt.event_id');	
					$dbAccess->where("evt.event_active", 1);
					$query = $dbAccess->get('events evt');

					
					$data['eventDetails'] = $query->result();

					//display the page
					$this->load->view('active_events_xml', $data);
					
				}
		}
	}
		
	function GetSellableOnlineEvents(){
	
		$appcode = $this->input->get_post('appcode');
		$livetoken = $this->input->get_post('livetoken');
		
		// Checks the existence of $appcode && $livetoken
		if (!$this->validatesession($appcode,$livetoken))
		{echo 'Invalid key pair';}
		
		// Check if Expired..if not yet expired..if not...
		elseif($this->checksessionexpiration($appcode,$livetoken))
			{ echo 'LiveToken expired';}
			else{	

			$dbAccess = $this->load->database('default',true);
			$this->load->dbutil();

					$dbAccess->select("
					evt.event_id
					,evt.event_code
					, evt.event_long_title
				");
							
			$dbAccess->where("evt.event_active", 1);
			$dbAccess->where("evt.event_internet_sales_charge IS NOT null");
			$dbAccess->where("events_config.events_config_ekbarcode_active", 0);
			$dbAccess->join('events_config', 'events_config.events_config_eventid = evt.event_id');
		
			$query = $dbAccess->get('events evt');
		
			
			
			$config = array (
				  'root'    => 'root',
				  'element' => 'eventinfo', 
				  'newline' => "\n", 
				  'tab'    => "\t"
				);
				
			$xmloutput = $this->dbutil->xml_from_result($query, $config);
			echo $xmloutput;
		}
	}
	
	function GetVenueListForAllActiveEvents(){
		$appcode = $this->input->get_post('appcode');
		$livetoken = $this->input->get_post('livetoken');
		
		
		
		if(!$appcode){
			$this->promptError('ER:01:03');
		}elseif(!$livetoken){
			$this->promptError('ER:01:04');
		}else
		{
		
			// Checks the existence of $appcode && $livetoken
			if (!$this->validatesession($appcode,$livetoken))
			{
				// echo 'Invalid key pair';
				$this->promptError('ER:02:02');
			}
			
			// Check if Expired..if not yet expired..if not...
			elseif($this->checksessionexpiration($appcode,$livetoken))
			{ 
				// echo 'LiveToken expired';
				$this->promptError('ER:03:01');
			}
			else
			{	 

	
				$dbAccess = $this->load->database('default',true);

				$dbAccess->select("	v.venue_id
									,v.venue_type
									, v.venue_name
									, v.venue_address1
					");
					$dbAccess->distinct();
				$dbAccess->join('events e','e.event_venue_id = v.venue_id');
				$dbAccess->where('e.event_active',1);
				
					

				$query = $dbAccess->get('venues v');
				$content = $query->result();
				$data['Venues'] = $content;
				$this->load->view('venues_xml', $data);
			}
	
		}
	}
		
	function GetSections(){
		$appcode = $this->input->get_post('appcode');
		$livetoken = $this->input->get_post('livetoken');
		
		if(!$appcode){
			$this->promptError('ER:01:03');
		}elseif(!$livetoken){
			$this->promptError('ER:01:04');
		}else{

			//Checks the existence of $appcode && $livetoken
			if (!$this->validatesession($appcode,$livetoken))
			{$this->promptError('ER:02:02');}
			
			//Check if Expired..if not yet expired..if not...
			elseif($this->checksessionexpiration($appcode,$livetoken))
				{ $this->promptError('ER:03:01');}
			else{	
				
		
				$seatplanID = $this->input->get_post('seatplanid');
				
				if(!$seatplanID ){
					$this->promptError('ER:05:01');
				}else{
					
					//get seatplan
					// $data['seatplan'] = $this->seatplans->get($seatplanID);
					
					// get sections
					$arr_sid = $this->sections->get_section_ids_array($seatplanID);
					
					if (count($arr_sid) > 0) {
						$sections_info = $this->sections->get_ticket_availability_sections(serialize($arr_sid), $seatplanID, true);
					} else {
						$sections_info = array();
					}	
					
				
					
					$data['sections_info'] = $sections_info;
					$data['sections'] = $this->sections->get_sections($seatplanID);
					// print_r($data['sections']);		
				
					if(!$data['sections']){
						$this->promptError('ER:05:02');
					}else{
					//display the page
					$this->load->view('seatplans_xml', $data);

					}
				
				}
			}
		}
	}

	function GetSectionsforAllActiveEvents(){

	$appcode = $this->input->get_post('appcode');
	$livetoken = $this->input->get_post('livetoken');
	
	if(!$appcode){
		$this->promptError('ER:01:03');
	}elseif(!$livetoken){
		$this->promptError('ER:01:04');
	}else{

		//Checks the existence of $appcode && $livetoken
		if (!$this->validatesession($appcode,$livetoken))
		{$this->promptError('ER:02:02');}
		
		//Check if Expired..if not yet expired..if not...
		elseif($this->checksessionexpiration($appcode,$livetoken))
			{ $this->promptError('ER:03:01');}
		else{	

				$data['sections'] = $this->sections->getSectionsWithEventID();

				if(!$data['sections']){
					$this->promptError('ER:05:02');
				}else{
				//display the page
				$this->load->view('seatplans_active_events_xml', $data);
				
				
				}
		
		}
	
}

}

	function GetUsedSectionInfoForAllActiveEvents(){

		$appcode = $this->input->get_post('appcode');
		$livetoken = $this->input->get_post('livetoken');
		
		if(!$appcode){
			$this->promptError('ER:01:03');
		}elseif(!$livetoken){
			$this->promptError('ER:01:04');
		}else{

			//Checks the existence of $appcode && $livetoken
			if (!$this->validatesession($appcode,$livetoken))
			{$this->promptError('ER:02:02');}
			
			//Check if Expired..if not yet expired..if not...
			elseif($this->checksessionexpiration($appcode,$livetoken))
				{ $this->promptError('ER:03:01');}
			else{	

					//display the page
					$this->load->view('seatplans_active_events_extra_xml');
					
					
					}
			
			}
		
	}
	
	/*
	function GetSectionsForAllActiveEvents(){
		$appcode = $this->input->get_post('appcode');
		$livetoken = $this->input->get_post('livetoken');
		
		if(!$appcode){
			$this->promptError('ER:01:03');
		}elseif(!$livetoken){
			$this->promptError('ER:01:04');
		}else{

			//Checks the existence of $appcode && $livetoken
			if (!$this->validatesession($appcode,$livetoken))
			{$this->promptError('ER:02:02');}
			
			//Check if Expired..if not yet expired..if not...
			elseif($this->checksessionexpiration($appcode,$livetoken))
				{ $this->promptError('ER:03:01');}
				
			else{	

					//get sections
					$arr_sid = $this->sections->get_section_ids_for_all_seatplan_array();
				
				if (count($arr_sid) > 0) {
						$sections_info = $this->sections->get_ticket_availability_sections(serialize($arr_sid), $seatplanID, true);
					} else {
						$sections_info = array();
					}
					
					$data['sections_info'] = $sections_info;
					$data['sections'] = $this->sections->get_all_sections();
					// print_r($data['sections']);		
				
					if(!$data['sections']){
						$this->promptError('ER:05:02');
					}else{
					//display the page
					$this->load->view('seatplans_xml', $data);
					}
				
			}
		}
	}
	
	*/
	
	function Getprices(){
		
			$eventID = $this->input->get_post('eventid');
			
			$appcode = $this->input->get_post('appcode');
			$livetoken = $this->input->get_post('livetoken');
			
			if(!$appcode){
				$this->promptError('ER:01:03');
			}elseif(!$livetoken){
				$this->promptError('ER:01:04');
			}elseif(!$eventID){
				$this->promptError('ER:05:03');
			}else{
			
				//Checks the existence of $appcode && $livetoken
				if (!$this->validatesession($appcode,$livetoken))
				{$this->promptError('ER:02:02');}
				
				//Check if Expired..if not yet expired..if not...
				elseif($this->checksessionexpiration($appcode,$livetoken))
				{$this->promptError('ER:03:01');}
				else{	
				
					// get ticket prices
					$data['prices'] = $this->prices->get_prices($eventID);
							
					// get the event info
					$data['event'] = $this->events->get($eventID);
					
					if(!$data['event']){
						$this->promptError('ER:05:04');
					}else{
						$this->load->view('prices_xml', $data);
					}
				}
			}

		}
		
	function GetPriceSectionForAllActiveEvents(){
		
			// $eventID = $this->input->get_post('eventid');
			$appcode = $this->input->get_post('appcode');
			$livetoken = $this->input->get_post('livetoken');
			
			if(!$appcode){
				$this->promptError('ER:01:03');
			}elseif(!$livetoken){
				$this->promptError('ER:01:04');
			}
			// elseif(!$eventID){
				// $this->promptError('ER:05:03');
			// }
			else{
			
				//Checks the existence of $appcode && $livetoken
				if (!$this->validatesession($appcode,$livetoken))
				{$this->promptError('ER:02:02');}
				
				//Check if Expired..if not yet expired..if not...
				elseif($this->checksessionexpiration($appcode,$livetoken))
				{$this->promptError('ER:03:01');}
				else{	
				
			
					$data['prices'] = $this->prices->getPricesForAllEvents();

						$this->load->view('prices_active_events_xml', $data);
			
				}
			}

		}
			
	function GetSectionPrices(){
		$appcode = $this->input->get_post('appcode');
		$livetoken = $this->input->get_post('livetoken'); 
 		$eventid = $this->input->get_post('eventid');

		
	 	if(!$appcode){
			$this->promptError('ER:01:03');
		}elseif(!$livetoken){
			$this->promptError('ER:01:04');
		}elseif (!$eventid)
		{
			// echo 'ER:05:03 No  Event ID Provided';
			$this->promptError('ER:05:03');
		}else{
		
			//Checks the existence of $appcode && $livetoken
			if (!$this->validatesession($appcode,$livetoken))
			{$this->promptError('ER:02:02');}
			
			//Check if Expired..if not yet expired..if not...
			elseif($this->checksessionexpiration($appcode,$livetoken))
			{ $this->promptError('ER:03:01');}
			else{	 
		
				// get event
				$event = $this->events->get($eventid);
				
				if(!$event){
					$this->promptError('ER:05:04');
				}else{
				
					$data['event'] = $event;

					// get prices
					$prices = $this->prices->get_prices($event->event_id);

					$array = array();

					$get_section_names = $this->sections->get_sections($event->event_seatplan_id);
					if ($get_section_names)
					{
					foreach($get_section_names as $r)
					$array[$r->section_id] = $r->section_name;
					}
					$data['section_names'] = $array;


					$priceseclist = array();
					foreach($prices as $price):
					$price_section_info = $this->sections->get_ticket_availability($price->price_sections, $event->event_seatplan_id, true, true);
					$section_type = $price_section_info['type'];
					// if (strtolower($section_type) == "reserved") {
					// $available = $price_section_info['total_available_db'];
					// } else {
					$available = $price_section_info['total_available'];
					// }

					$priceseclist[] = array(
					$price->price_name,
					($available > 0)? "" : "*SOLD OUT",
					($section_type == 'Reserved') ? 'Reserved Seats' : $section_type,
					$price->price_price,
					unserialize($price->price_sections),
					$price_section_info,
					$price->price_id,
					);
					endforeach;
					$data['priceseclist'] = $priceseclist;
					
					// display the page
					$this->load->view('section_prices_xml', $data);
				}
			}
		
		}
	}
	
	function GetOpenSeats(){
		$appcode = $this->input->get_post('appcode');
		$livetoken = $this->input->get_post('livetoken'); 
		$section_id = $this->input->get_post('sectionid');
		$price_id = $this->input->get_post('priceid');
 
	 
		if(!$appcode){
			$this->promptError('ER:01:03');
		}elseif(!$livetoken){
			$this->promptError('ER:01:04');
		}elseif(!$section_id){
			$this->promptError('ER:05:05');
		}elseif(!$price_id){
			$this->promptError('ER:05:07'); 
		}else{
  
			//Checks the existence of $appcode && $livetoken
			if (!$this->validatesession($appcode,$livetoken)){
				$this->promptError('ER:02:02');
			}elseif($this->checksessionexpiration($appcode,$livetoken)){  
				$this->promptError('ER:03:01');
			}else{	 
				 
				// validate section_id and price_id by retrieving event_id
					$event_id = $this->events->get_event_id($price_id, $section_id);
					$section = $this->sections->get($section_id);
					
			
					$event = $this->events->get($event_id);
					if(!$event){
						$this->promptError('ER:05:14');
					}else{
					$data['seat_count'] = $this->sections->get_ticket_availability($section_id, $event->event_seatplan_id); 		
					$data['section_info'] = $this->sections->get_section_info($section_id);		
					$data['seats_taken'] = $this->tickets->get_sold_seats($event_id, $section_id);	
					$data['seat_config'] = unserialize($section->section_seat_config);
					$data['section'] = $section;
					// display the page
					$this->load->view('open_seats_xml', $data);
					}
						
				
			}	
		}
	
	}
	
	function GetAllSeats(){
	
		$appcode = $this->input->get_post('appcode');
		$livetoken = $this->input->get_post('livetoken'); 
		$section_id = $this->input->get_post('sectionID');
		$price_id = $this->input->get_post('priceID');
		
		if(!$appcode){
			$this->promptError('ER:01:03');
		}elseif(!$livetoken){
			$this->promptError('ER:01:04');
		}elseif(!$section_id){
			$this->promptError('ER:05:05');
		}elseif(!$price_id){
			$this->promptError('ER:05:07');
		}else{

		
			//Checks the existence of $appcode && $livetoken
			if (!$this->validatesession($appcode,$livetoken))
			{$this->promptError('ER:02:02');}
			
			//Check if Expired..if not yet expired..if not...
			elseif($this->checksessionexpiration($appcode,$livetoken)){
				$this->promptError('ER:03:01');
			}else{	
				
				
				// validate section_id and price_id by retrieving event_id
				$event_id = $this->events->get_event_id($price_id, $section_id);
				$section = $this->sections->get($section_id);
				
				// get event info
				$event = $this->events->get($event_id);
				if(!$event){
					$this->promptError('ER:05:14');
				}else{
					$data['seat_count'] = $this->sections->get_ticket_availability($section_id, $event->event_seatplan_id); 	 
					$data['section_info'] = $this->sections->get_section_info($section_id);		
					$data['seats_taken'] = $this->tickets->get_reserved_seats($event_id, $section_id);	
					$data['seat_config'] = unserialize($section->section_seat_config);
					$data['section'] = $section;
					
					// display the page
					$this->load->view('all_seats_xml', $data); 
				}
			}
		}
	}
	
	function GetTicketTypes(){
		
		$appcode = $this->input->get_post('appcode');
		$livetoken = $this->input->get_post('livetoken');
		$eventID = $this->input->get_post('eventid');
			
		if(!$appcode){
			$this->promptError('ER:01:03');
		}elseif(!$livetoken){
			$this->promptError('ER:01:04');
		}elseif(!$eventID){
			$this->promptError('ER:05:03');
		}else{
		 
			//Checks the existence of $appcode && $livetoken
			if (!$this->validatesession($appcode,$livetoken))
			{$this->promptError('ER:02:02');}
			
			//Check if Expired..if not yet expired..if not...
			elseif($this->checksessionexpiration($appcode,$livetoken)){ 
				$this->promptError('ER:03:01');
			}else{	 
				$data['ticket_types'] = $this->ticket_types->get($eventID);
				$this->load->view('ticket_types_xml', $data); 
			}
		}
	}
	
	function GetTicketTypesStandard(){
	
		$appcode = $this->input->get_post('appcode');
		$livetoken = $this->input->get_post('livetoken');
			
		if(!$appcode){
			$this->promptError('ER:01:03');
		}elseif(!$livetoken){
			$this->promptError('ER:01:04');
		}
		else{
			//Checks the existence of $appcode && $livetoken
			if (!$this->validatesession($appcode,$livetoken))
			{$this->promptError('ER:02:02');}
			
			//Check if Expired..if not yet expired..if not...
			elseif($this->checksessionexpiration($appcode,$livetoken)){ 
				$this->promptError('ER:03:01');
			}else{	 
				$data['ticket_types'] = $this->ticket_types->get_ticket_types();
				
				 $this->load->view('all_ticket_types_xml.php', $data); 
			}
		}
	
	
	
	
	
	}
	
	function GetTicketTypesForAllActiveEvents(){
		
		$appcode = $this->input->get_post('appcode');
		$livetoken = $this->input->get_post('livetoken');
			
		if(!$appcode){
			$this->promptError('ER:01:03');
		}elseif(!$livetoken){
			$this->promptError('ER:01:04');
		}
		else{
		 
			//Checks the existence of $appcode && $livetoken
			if (!$this->validatesession($appcode,$livetoken))
			{$this->promptError('ER:02:02');}
			
			//Check if Expired..if not yet expired..if not...
			elseif($this->checksessionexpiration($appcode,$livetoken)){ 
				$this->promptError('ER:03:01');
			}else{	 
				$data['ticket_types'] = $this->ticket_types->getwithActiveEvents();
				
				 $this->load->view('ticket_types_xml', $data); 
			}
		}
	}
	
	function getSoldSeats(){
		
		$appcode = $this->input->get_post('appcode');
		$livetoken = $this->input->get_post('livetoken');
		$section_id = $this->input->get_post('sectionID');
		$price_id = $this->input->get_post('priceID');


		if(!$appcode){
			$this->promptError('ER:01:03');
		}elseif(!$livetoken){
			$this->promptError('ER:01:04');
		}else{
			if (!$section_id)
			{
				$this->promptError('ER:05:05');
			}elseif(!$price_id){
				$this->promptError('ER:05:07');
			}else{
			
				//Checks the existence of $appcode && $livetoken
				if(!$this->validatesession($appcode,$livetoken))
				{
				// echo 'Invalid key pair';
				$this->promptError('ER:02:02');
				}
				
				//Check if Expired..if not yet expired..if not...
				elseif($this->checksessionexpiration($appcode,$livetoken))
				{ 
					// echo 'liveToken expired';
					$this->promptError('ER:03:01');
				}else{
			 
					// validate section_id and price_id by retrieving event_id
					$event_id = $this->events->get_event_id($price_id, $section_id);
					$section = $this->sections->get($section_id);
						
					if(!$section){
						$this->promptError('ER:05:10');
					}else{
						
						$data['section_info'] = $this->sections->get_section_info($section_id);
						$data['sold_count'] = $this->tickets->get_sold_count($event_id, $section_id);
						$data['sold_seats'] = $this->tickets->get_sold_seats($event_id, $section_id);
						
						if(!$data['sold_seats']){
							$this->promptError('ER:05:11');
						}else{
							$this->load->view('sold_seats_xml', $data);
						}
						
					}
				}		
			}
		
		}
	}

	function getSelectedSeats(){
		
		$appcode = $this->input->get_post('appcode');
		$livetoken = $this->input->get_post('livetoken');
		$section_id = $this->input->get_post('sectionID');
		$price_id = $this->input->get_post('priceID');


		if(!$appcode){
			$this->promptError('ER:01:03');
		}elseif(!$livetoken){
			$this->promptError('ER:01:04');
		}else{
			if (!$section_id)
			{
				$this->promptError('ER:05:05');
			}elseif(!$price_id){
				$this->promptError('ER:05:07');
			}else{
			
			
				//Checks the existence of $appcode && $livetoken
				if(!$this->validatesession($appcode,$livetoken))
				{
				// echo 'Invalid key pair';
				$this->promptError('ER:02:02');
				}
				
				//Check if Expired..if not yet expired..if not...
				elseif($this->checksessionexpiration($appcode,$livetoken))
				{ 
					// echo 'liveToken expired';
					$this->promptError('ER:03:01');
				}else{
				 
					// validate section_id and price_id by retrieving event_id
					$event_id = $this->events->get_event_id($price_id, $section_id);
					$section = $this->sections->get($section_id);
						
					if(!$section){
						$this->promptError('ER:05:10');
					}else{
						
							$data['section_info'] = $this->sections->get_section_info($section_id);
							$data['selected_count'] = $this->tickets->get_selected_count($event_id, $section_id);
							$data['selected_seats'] = $this->tickets->get_selected_seats($event_id, $section_id);
							
							if(!$data['selected_seats']){
								$this->promptError('ER:05:13');
							}else{
								$this->load->view('selected_seats_xml', $data);
							}
						
					}
				}	
					
			}
		
		}
	}

	function GetReservedSeats(){
		
		$appcode = $this->input->get_post('appcode');
		$livetoken = $this->input->get_post('livetoken');
		$section_id = $this->input->get_post('sectionID');
		$price_id = $this->input->get_post('priceID');


		if(!$appcode){
			$this->promptError('ER:01:03');
		}elseif(!$livetoken){
			$this->promptError('ER:01:04');
		}else{
			if (!$section_id)
			{
				$this->promptError('ER:05:05');
			}elseif(!$price_id){
				$this->promptError('ER:05:07');
			}else{
			
				//Checks the existence of $appcode && $livetoken
				if(!$this->validatesession($appcode,$livetoken))
				{
				// echo 'Invalid key pair';
				$this->promptError('ER:02:02');
				}
				
				//Check if Expired..if not yet expired..if not...
				elseif($this->checksessionexpiration($appcode,$livetoken))
				{ 
					// echo 'liveToken expired';
					$this->promptError('ER:03:01');
				}else{
			
					// validate section_id and price_id by retrieving event_id
					$event_id = $this->events->get_event_id($price_id, $section_id);
					$section = $this->sections->get($section_id);
						
					if(!$section){
						$this->promptError('ER:05:10');
					}else{
						
							$data['section_info'] = $this->sections->get_section_info($section_id);
							$data['reserved_count'] = $this->tickets->get_reserved_count($event_id, $section_id);
							$data['reserved_seats'] = $this->tickets->get_reserved_seats($event_id, $section_id);
							
							if(!$data['reserved_seats']){
								$this->promptError('ER:05:12');
							}else{
								$this->load->view('reserved_seats_xml', $data);
							}
						
					}
				}	
			}
		
		}
	}
	
	function seat_layout_image() {
			
			$appcode = $this->input->get_post('appcode');
			$livetoken = $this->input->get_post('livetoken');
			$seatplanid = $this->input->get_post('seatplanid');
			
			if(!$appcode){
				$this->promptError('ER:01:03');
			}elseif(!$livetoken){
				$this->promptError('ER:01:04');
			}elseif(!$seatplanid){
				$this->promptError('ER:05:01');
			}
			else{

				
				// Checks the existence of $appcode && $livetoken
				if (!$this->validatesession($appcode,$livetoken))
				{
				// echo '$appcode/$livetoken does not exist';
				$this->promptError('ER:02:02');
				}
				
				// Check if Expired..if not yet expired..if not...
				elseif($this->checksessionexpiration($appcode,$livetoken))
					{
						// echo '$Appcode/$liveToken expired';
						$this->promptError('ER:03:01');
					}
					else{	
				
								$dbAccess = $this->load->database('default',true);
								
								
								$dbAccess->select("
										seatplans.seatplan_image,
										seatplans.seatplan_name,
										venues.venue_name
									");
									
								$dbAccess->where("seatplans.seatplan_id", $seatplanid);
								$dbAccess->join('venues', 'venues.venue_id = seatplans.seatplan_venue_id');
								$query = $dbAccess->get('seatplans');

								if($query->num_rows() < 1){
									$this->promptError('ER:05:02');
								}else{
								
									$this->load->dbutil();
									
									$config = array (
										  'root'    => 'root',
										  'element' => 'seatinfo', 
										  'newline' => "\n", 
										  'tab'    => "\t"
										);
										
									$xmloutput = $this->dbutil->xml_from_result($query, $config);
									echo $xmloutput;
								
								}
								
						}
					
			}		
		
		}
	
	function check_expiry_datasync() {
	
		$data['value'] = 0;
		
		$appcode = $this->input->get_post('appcode');
		$livetoken = $this->input->get_post('livetoken'); 
		
		if(!$appcode){
			return $this->promptError('ER:01:03');
		}
		elseif(!$livetoken){
			return $this->promptError('ER:01:04');
			
		}
			//Checks the existence of $appcode && $livetoken
			elseif (!$this->validatesession($appcode,$livetoken))
			{
			return $this->promptError('ER:02:02');
			}
			
			//Check if Expired..if not yet expired..if not...
			elseif(!$this->checksessionexpiration($appcode,$livetoken)){
			$data['value'] = 1;
			}
			
			// display the page
			$this->load->view('expiration_xml', $data);
			
			
		
	}
	
	function check_expiry_purchase() {
		
		$data['value'] = 1;
		$accessCode =  $this->input->get_post("accesscode"); 
		$dynaToken =  $this->input->get_post("dynatoken"); 
		
		if(!$accessCode){
			return $this->promptError('ER:01:06');
		}elseif(!$dynaToken){
			return $this->promptError('ER:01:08');
		}
		else{
		
		// verify access credentials before processing order request
			$result = $this->transaction->verify_access_token($accessCode, $dynaToken);
			
			if($result == 'expired'){ 
				$data['value'] = 0;
			}elseif($result == 'inactive'){ 
				$data['value'] = 0;
			}elseif($result == 'invalid'){ 
				$data['value'] = 0; 
			}
		
				
			// display the page
			$this->load->view('expiration_xml', $data);
		}
	
	
	}

	function GetVideoURLForAllActiveEvents(){
	
		$appcode = $this->input->get_post('appcode');
		$livetoken = $this->input->get_post('livetoken');
		
		if(!$appcode){
			$this->promptError('ER:01:03');
		}elseif(!$livetoken){
			$this->promptError('ER:01:04');
		}else{
			
				// Checks the existence of $appcode && $livetoken
				if (!$this->validatesession($appcode,$livetoken))
				{$this->promptError('ER:02:02');}
				
				// Check if Expired..if not yet expired..if not...
				elseif($this->checksessionexpiration($appcode,$livetoken))
					{ $this->promptError('ER:03:01');}
					
				else{		
	
	
					$dbAccess = $this->load->database('default',true);
	
	
					$dbAccess->select("
							evt.event_id
							, evt.event_long_title
						");
					$dbAccess->where("evt.event_active", 1);
					$query = $dbAccess->get('events evt');

					$EventArray = $query->result();
			
					foreach ($EventArray as $a) {
						$a->event_long_title = preg_replace("/[^0-9a-z]/","", strtolower($a->event_long_title));
					}
					
							
					$query = $dbAccess->query('SELECT p.page_uri, p.page_content, "" as eventID FROM pages p');
					$PagesArray = $query->result();
					
					foreach ($PagesArray as $p){
						$p->page_content = strstr(strstr($p->page_content, 'http://www.youtube.com'), '"', true) ;
						
						foreach($EventArray as $e)
						{
							if($e->event_long_title == $p->page_uri)
							{
							$p->eventID = $e->event_id;
							}
						}

					}
					
					
				$eventvideoArray = $PagesArray;
					
						foreach($eventvideoArray as $k => $ev)
						{
							if(empty($ev->eventID))
							{
							unset($eventvideoArray[$k]);
							}
						}

			$data['eventDetails'] = $eventvideoArray;
					

					//display the page
					
					$this->load->view('video_url_xml', $data);
					
	
	
					}
	
	}
	
	}

//----------------------------------------------------------------------------	
/*======= OTHER FUNCTIONS ======= */
			//Checks the existence of partycode and its corresponding usecode..Returns true if exists
			function verifyparty($partycode=false,$usecode=false){
				$isvalid = false;
				
				$dbAccess = $this->load->database('default',true);
				$dbAccess->select("api_user_id");
				$dbAccess->where("partycode", $partycode);
				$dbAccess->where("usecode",  $usecode);
				$query = $dbAccess->get('api_party');

					if ($query->num_rows() > 0)
					{
					$isvalid = True;
					}
					
				return $isvalid;
			}
				
			//Checks the existence of $appcode && $livetoken ..Returns TRUE if exists
			function validatesession($appcode=false,$livetoken=false){
				$exists = false;
				
				$dbAccess = $this->load->database('default',true);
				$dbAccess->select("api_session_id");
				$dbAccess->where("api_apppcode", $appcode);
				$dbAccess->where("api_livetoken",  $livetoken);
				$query = $dbAccess->get('api_sessions');

					if ($query->num_rows() > 0)
					{
					$exists = True;
					}
					
				return $exists;
			}
			
			//Returns TRUE if the $appcode or $livetoken is already INACTIVE or EXPIRED
			function checksessionexpiration($appcode=false,$livetoken=false){
		
			$isExpired = false;

					//Get the latest appcode row
					$dbAccess = $this->load->database('default',true);
					$dbAccess->select('api_time_issued,api_duration,api_gen_active,api_livetoken');
					$dbAccess->where("api_apppcode", $appcode);
					$dbAccess->where("api_livetoken", $livetoken);
					$dbAccess->order_by('api_time_issued','desc');
					$dbAccess->limit(1);
					$query = $dbAccess->get('api_sessions');
					$row = $query->row_array();	
					
					if($row)
					{
					$livetoken = $row['api_livetoken'];
					$duration = $row['api_duration'];// in minutes; 
					$issuetime =  $row['api_time_issued'];//time when appcode was issued
					$active = $row['api_gen_active'];
					
					
							//Check if still active
							if($active == 1)
								{
								//Declare 
								date_default_timezone_set('Asia/Manila');
								$endtime = new DateTime($row['api_time_issued']);
								$endtime->modify("+" .$duration ." minutes");
								
								$endtime = $endtime->format('Y-m-d H:i:sP');

											
								
										//Compare $endtime to Current date
										if ($endtime < $this->getcurrentdatetime())
										{
											//expired
											$isExpired = True;
											
											//Deactivate
											$isdeactivated = false;
											$isdeactivated = $this->session_deactivate($appcode,$livetoken);
										
											if (!$isdeactivated){
											echo 'Unable to deactivate an appcode/livetoken';
											}
										}
										else
										{
										$isExpired = False;
										}
								}
								elseif($active == 0)
								{
									$isExpired = True;						
								}
						else
						{
						echo 'Unable to retrieve expiration data';
						}
	
					}			
					else
					{
					echo 'Appcode does not exist in the database';
					}
		
	return 	$isExpired;												
	}
	
			//Deactivates an $appcode/$livetoken
			function session_deactivate($appcode=false,$livetoken=false){
				$success = false;
				$dbAccess = $this->load->database('default',true);
				
				//Validate existence of appcode and livetoken...
						$dbAccess->select("api_session_id");
						$dbAccess->where('api_apppcode',$appcode);
						$dbAccess->where('api_livetoken',$livetoken);
						$query = $dbAccess->get('api_sessions');
						
						$row = $query->row_array();
						

							if ($query->num_rows() > 0)
							{
							// update api_gen_active from 1 to 0
							$data = array('api_gen_active' => 0);
							$dbAccess->where('api_apppcode',$appcode);
							$dbAccess->update('api_sessions', $data); 	
							$success = true;
							}
				return $success;
			}

			//NOTE..$partycode,$usecode and $time are mixed together to  generate an $appcode
			function generateAppCode($partycode = false, $usecode=false, $time=false){
			$appcode = $this->encrypt->sha1($partycode.'MGI'.$usecode.'MGI'.$time );
			return $appcode;
			}
			
			//NOTE..$appcode and $time are mixed together to  generate a $livetoken
			function generatelivetoken($appcode=false){
			$livetoken = $this->encrypt->sha1($appcode.'MGI'.$this->getcurrentdatetime().'MGI');
			return $livetoken;
			}
			
			//Returns an array of party platform,browser, ipAdress and referrer
			function getpartycredentials(){
			$partycredentials = false;
			
			$partycredentials = array(
			'platform' =>  $this->agent->platform(),
			'browser' =>  $this->agent->browser().' '.$this->agent->version(),
			'ipaddress' =>  $this->input->ip_address(),
			'referrer:' => $this->agent->referrer()
			);
			return $partycredentials;
			}
			
			//Get $partycode from sessions by appcode/liveToken
			function getpartycodebyappcode($appcode){
			$partycode = false;

				$dbAccess = $this->load->database('default',true);
				$dbAccess->select("api_partycode");
				$dbAccess->where("api_apppcode", $appcode);
				$dbAccess->limit(1);
				$query = $dbAccess->get('api_sessions');

					if ($query->num_rows() > 0){
					$row = $query->row();	
					$partycode = $row->api_partycode;
					}
					else
					{
					echo 'Unable to retrieve partycode from the database'; 
					}

			return $partycode;

			}

			//Check  api_customer_email ,api_customer_email  column if a certain record already exist..
			function check_dbcolumn($value=false){
			$exist = false;
				$dbAccess = $this->load->database('default',true);
				$dbAccess->where("api_customer_mobile", $value);
				$dbAccess->or_where('api_customer_email', $value);
				$query = $dbAccess->get('api_party_customers');
					
										if ($query->num_rows() > 0)
											{
											$exist = true;
											}

			return $exist;
			}
			
			function check_username($value=false){
				$exist = false;
				$dbAccess = $this->load->database('default',true);
				$dbAccess->where("api_customer_username", $value);;
				$query = $dbAccess->get('api_party_customers');

					if ($query->num_rows() > 0)
						{
						$exist = true;
						}

			return $exist;
			}
				
			function checkmobilenumber($cid = false, $mobileNumber=false){
			$exist = false;
			$dbAccess = $this->load->database('default',true);
			$dbAccess->where("api_customer_mobile", $mobileNumber);
			$dbAccess->where("api_customer_id <>", $cid);
			$query = $dbAccess->get('api_party_customers');
				
			if ($query->num_rows() > 0)
				{
				$exist = true;
				}
			return $exist;
			}

			function checkemail($cid = false, $email=false){
			$exist = false;
			$dbAccess = $this->load->database('default',true);
			$dbAccess->where("api_customer_email", $email);
			$dbAccess->where("api_customer_id <>", $cid);
			$query = $dbAccess->get('api_party_customers');
				
			if ($query->num_rows() > 0)
				{
				$exist = true;
				}
			return $exist;
			}
			
			//Current Time
			function getcurrentdatetime(){
			//Set Current Date
			$date = new DateTime(null, new DateTimeZone('Asia/Manila'));
			return $date = $date->format('Y-m-d H:i:sP');
		}
			
			//Returns TRUE if date format = YYYY-MM-DD
			//sample..	2011-02-14
			function isValidDate($date){
				if(preg_match("/^(\d{4})-(\d{2})-(\d{2})$/", $date, $matches))
				{
					if(checkdate($matches[2], $matches[3], $matches[1]))
					{
						return true;
					}
				}
			}
			
			function prep_password($password){
				return sha1($this->config->item('encryption_key').$password);
			}

			//Checks the existence of $appcode ..Returns TRUE if exists
			function checkappcode($appcode){
			$exist = false;
			$dbAccess = $this->load->database('default',true);
				$dbAccess->select("api_apppcode");
				$dbAccess->where("api_apppcode", $appcode);
				$query = $dbAccess->get('api_sessions');
				
				if ($query->num_rows() > 0)
				{
				$exist = true;
				}
				return $exist;
			}
			 
			//=================================================================
			function seats_quantity($section_id = false, $event_id = false){

// get event info
$event = $this->events->get($event_id);

$data['section_info'] = $this->sections->get_section_info($section_id);
$data['seat_info'] = $this->sections->get_ticket_availability($section_id, $event->event_seatplan_id);
$this->load->view('seats_quantity_xml', $data);

}

			function validate_phonenumbers($number = false) {
				// can specify any format indicated below		
				$formats = array(
					// 13 to 14 char +63917-000-0000
					'+############', 
					'+#############', 
					'+##############', 
					// from 11-digit to 15-digit number
					'###########',
					'############',
					'#############',
					'##############',
					'###############',
				);

				/*
				Add following format when possible:
				+639200000000
				+63 920 000 0000
				+63 920 0000000
				639200000000
				63 920 000 0000
				63 920 0000000
				09200000000
				0920 0000000		
				*/

				$format = trim(preg_replace("/[0-9]/", "#", $number));
				return (in_array($format, $formats)) ? true : false;
			}
	
			

}
